﻿using System;
using System.Collections.Generic;

public class FinancialAdvisor : IBroker, IAdvisor
{
    Dictionary<string, Stock> m_stocks = new Dictionary<string, Stock>();
    decimal pricePerTrade;
    decimal fee;
    string brokerName;

    public FinancialAdvisor()
        : this(13.59m, 11.73m, "Anonimowy")
    {
    }

    public FinancialAdvisor(decimal tradePrice,
                       decimal fee,
                       string brokerName)
    {
        pricePerTrade = tradePrice;
        this.fee = fee;
        this.brokerName = brokerName;
    }

    string IBroker.GetRating(string stock)
    {
        Stock myStock = (Stock)m_stocks[stock];
        return Enum.GetName(typeof(StockRating),
                      myStock.Rating);
    }

    string IAdvisor.GetRating(string stock)
    {
        Stock myStock = (Stock)m_stocks[stock];
        return Enum.GetName(typeof(StockRating),
                       (((int)++myStock.Rating) % 5));
    }

    private StockRating AssignRating(Stock newStock)
    {
        Random myRand = new Random();
        int nextRating = myRand.Next(4);
        return (StockRating)Enum.ToObject(
                            typeof(StockRating),
                            nextRating);
    }

    decimal IAdvisor.HourlyFees
    {
        get
        {
            return fee;
        }
        set
        {
            fee = value;
        }
    }

    public decimal PricePerTrade
    {
        get
        {
            return pricePerTrade;
        }
        set
        {
            pricePerTrade = value;
            PriceChange(brokerName, value);
        }
    }

    public decimal this[string StockName]
    {
        get
        {
            Stock myStock = (Stock)m_stocks[StockName];
            return myStock.Price;
        }
        set
        {
            Stock myStock = new Stock();
            myStock.Name = StockName;
            myStock.Price = value;
            myStock.Rating = AssignRating(myStock);

            m_stocks.Add(StockName, myStock);
        }
    }

    public event ChangeRegistrar PriceChange;
}
